<head>
    <script>
        function obtenerNumeroCorrelativo() {
            var tipo = document.getElementById("tipo_cpe").value;
            var xhr = new XMLHttpRequest();
            xhr.open("POST", "/Botica/views/compras/mostrar_comprobantes.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onload = function () {
                if (xhr.status === 200) {
                    // Actualizar el valor del campo de texto con el resultado recibido
                    document.getElementById("numero_correlativo").value = xhr.responseText;
                } else {
                    document.getElementById("numero_correlativo").value = "Error al obtener el número.";
                }
            };
            xhr.send("tipo_cpe=" + encodeURIComponent(tipo));
        }
    </script>
    <script>
        // Cambiar color al enfocar
        function changeColor(element, color) {
            element.style.backgroundColor = color;
        }
        // Restaurar color al salir
        function resetColor(element) {
            element.style.backgroundColor = '';
        }
    </script>
</head>

<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">Nueva compra</h1>
</div>

<div class="row">
    <div class="col-md-5">
        <div class="card">
            <div class="card-body">
                <div class="input-group mb-3">
                    <div class="input-group-prepend">
                        <span class="input-group-text"><i class="fas fa-search"></i></span>
                    </div>
                    <input type="text" class="form-control" placeholder="Barcode" id="seacrh">
                </div>
                <div class="table-responsive">
                    <table class="table" id="table_temp" style="width: 100%;">
                        <thead>
                            <tr>
                                <th scope="col">Nombre</th>
                                <th scope="col">Precio</th>
                                <th scope="col">Cant</th>
                                <th scope="col">SubTotal</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
                <div class="d-flex justify-content-between">
                    <h5>Datos del proveedor</h5>
                    <button class="btn btn-info" data-toggle="modal" data-target="#modal-proveedor"><i
                            class="fas fa-search"></i> Proveedor</button>
                </div>
                <hr>
                <div class="row">
                    <input type="hidden" id="id-proveedor" value="1">
                    <div class="col-md-12">
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fas fa-users"></i></span>
                            </div>
                            <input type="text" class="form-control" id="nombre-proveedor" placeholder="Proveedor"
                                readonly>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fas fa-address-book"></i></span>
                            </div>
                            <input type="text" class="form-control" id="doc-proveedor" placeholder="DNI/RUC" readonly>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fas fa-home"></i></span>
                            </div>
                            <input type="text" class="form-control" id="dir-proveedor" placeholder="Dirección" readonly>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label for=""><strong style="font-size:16px; color:rgb(25,54,93);">&nbsp;Fecha
                                Documento</strong><span class="text-danger">*</span></label>
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fas fa-clipboard-list"></i></span>
                            </div>
                            <input type="date" style="font-size:14px;" class="form-control font-weight-bold"
                                id="FechaSunat" name="FechaSunat" value="<?php date_default_timezone_set('America/Lima');
                                echo date("Y-m-d"); ?>" onfocus="changeColor(this, '#f7f201')"
                                onblur="resetColor(this)">
                        </div>
                    </div>

                    <form id="formulario" onsubmit="event.preventDefault(); obtenerNumeroCorrelativo();">
                        <label for="tipo_cpe"><strong style="font-size:16px; color:rgb(25,54,93);">&nbsp;Tipo de
                                Documento</strong><span class="text-danger">*</span></label>
                        <div class="input-group mb-3">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fa fa-calendar-check"></i></span>
                            </div>
                            <select class="form-control" id="tipo_cpe" name="tipo_cpe"
                                style="cursor:pointer; width:180px;font-size:16px; font-weight-bold;"
                                onfocus="changeColor(this, '#f7f201')" onblur="resetColor(this)"
                                onchange="obtenerNumeroCorrelativo();">
                                <option value="A">SELECCIONE</option>
                                <option value="L">LQ-COMPRA</option>
                            </select>
                            <button style="display:none;" type="submit">Mostrar Número Correlativo</button>
                        </div>
                        <div class="col-md-14">
                            <label for="numero_correlativo"><strong
                                    style="font-size:14px; color:rgb(25,54,93);">&nbsp;N° de
                                    Documento</strong><span class="text-danger">*</span></label>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fa fa-credit-card"></i></span>
                                </div>
                                <input type="text" class="form-control font-weight-bold" id="numero_correlativo"
                                    name="numero_correlativo" value="" readonly
                                    style="width:80px;font-size:20px;text-align:center;background-color: rgb(25,54,93);color: rgb(255,255,255);">
                            </div>
                        </div>
                    </form>

                    <div class="col-md-5">
                        <button type="button" class="btn btn-primary btn-block" id="btn-guardar"><i
                                class="fas fa-print"></i> Guardar</button>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="col-md-7">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table" id="table_compra" style="width: 100%;">
                                <thead class="thead-dark">
                                    <tr>
                                        <th scope="col">Barcode</th>
                                        <th scope="col">Nombre</th>
                                        <th scope="col">Stock</th>
                                        <th scope="col">Precio</th>
                                        <th>Accion</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Modal -->
<div class="modal fade" id="modal-proveedor" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Seleccionar proveedor</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table" id="table_proveedores" style="width: 100%;">
                        <thead class="thead-dark">
                            <tr>
                                <th scope="col">Nombre</th>
                                <th scope="col">DNI/RUC</th>
                                <th scope="col">Direccion</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>